class W3BoltSpellsfrozen extends W3AdvancedProjectile
{
	var boneName 					: name;
	var actorVictim					: CActor;
	var dmg_action                  : W3DamageAction;
	var victimsand					: CNewNPC;	
	var entities 					: array< CGameplayEntity >;
	var i,z 						: int;
	var lastCollisionFxPos 			: Vector;
	var spellpower 					: SAbilityAttributeValue;
	var damage						: Float;
	var ent 						: CEntity;
	var mesh						: CMeshComponent;

	timer function check_for_cancel(deltaTime : float, id : int) 
	{
		mesh = (CMeshComponent)GetComponentByClassName('CMeshComponent');
		mesh.SetScale( Vector( 0, 0, 0 ) );
		RemoveTimers();
		DestroyEffect('frozen');
		Destroy();
	}

	timer function play_eff( deltaTime : float , id : int)
	{
		PlayEffect('trail2');
	}
	
	event OnProjectileInit()
	{
		AddTimer('check_for_cancel', 0.4 );
		PlayEffect('frozen');
		PlayEffect('trail3');
		SoundEvent("monster_golem_ice_mv_foley_heavy");
	}
	
	event OnDestroyed()
	{
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		var meshComponent		: CMeshComponent;
		var arrowHitPos			: Vector;
		var arrowSize			: Vector;
		var boundingBox			: Box;
	
		if ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Static' ) )
		{
			StopAllEffects();
			StopProjectile();
			RemoveTimer('play_eff');
			this.DestroyAfter(5);
			
			this.SoundEvent("cmb_arrow_impact_dirt");
			
			arrowHitPos = pos;
			meshComponent = (CMeshComponent)GetComponentByClassName('CMeshComponent');
			if( meshComponent )
			{
				boundingBox = meshComponent.GetBoundingBox();
				arrowSize = boundingBox.Max - boundingBox.Min;
				arrowHitPos -= RotForward(  this.GetWorldRotation() ) * arrowSize.X * 0.7f; 
			}
			Teleport( arrowHitPos );
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		
		if( collidingComponent )
		{	
			actorVictim = (CActor)victim;
			
			if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile) && victim.IsAlive())
			{
			
				ent = theGame.CreateEntity( (CEntityTemplate)LoadResource( 'swordless_hits' ), pos  );
				ent.PlayEffect('axii_bolt_hit');
				ent.SoundEvent( 'ep2_mutations_09_bolt_impact_armor_type' );
				ent.DestroyAfter(3);
				
				deal_damage_swordless_spells( S_Magic_5, (CActor)victim, 6, theGame.params.DAMAGE_NAME_FROST, false );
				
				collidedEntities.PushBack(victim);
			}
		}
	}
}


class W3AardTrailM extends W3AdvancedProjectile
{
	var name0, name1, name2, name3	: name;
	var actorVictim					: CActor;
	var ent 						: CEntity;
	var poseffect,posttest			: Vector;
	var entities					: array< CGameplayEntity >;
	var i 							: Int;
	
	timer function check_for_cancel(deltaTime : float, id : int) 
	{
		RemoveTimers();
		Destroy();
	}
	
	timer function play_effect2(deltaTime : float, id : int) 
	{
		PlayEffect( name0 );
		PlayEffect( name1 );
		
	}

	event OnProjectileInit()
	{
		StopAllEffectsAfter(2);
		DestroyAfter(3);
		
		if ( FactsQuerySum("spells_aard_chosen_att_3") > 0 )
		{ 
			name0 = 'effects_90';
			name1 = 'effects_901';
			name2 = 'effects_902';
		}
		else if ( FactsQuerySum("spells_aard_chosen_att_1") > 0 )
		{ 
			name0 = 'effects_45_';
			name1 = 'effects_45_1';
			name2 = 'effects_45_2';
		}
		else if ( FactsQuerySum("spells_aard_chosen_att_2") > 0 )
		{
			name0 = 'effects_45';
			name1 = 'effects_451';
			name2 = 'effects_452';
		}
		
		PlayEffect( name2 );
		
		AddTimer('check_for_cancel',0.5 );
	}
	
	
	timer function check_targets_aard( deltaTime : float , id : int)
	{
		entities.Clear();
		FindGameplayEntitiesInSphere( entities, this.GetWorldPosition(), 0.5, 10 );
	
		if ( entities.Size() > 0 )
		for( i = 0; i < entities.Size(); i += 1 )
		{
			victim = entities[i];
			
			if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile) && victim.IsAlive())
			{
				deal_damage_swordless_spells( S_Magic_1, (CActor)victim, 6, theGame.params.DAMAGE_NAME_FORCE, false );
				
				poseffect = victim.GetWorldPosition();
				posttest = this.GetWorldPosition();
				poseffect.Z = posttest.Z;
				
				ent = ((CActor)victim).CreateFXEntityAtPelvis( 'swordless_hits', true );
				ent.PlayEffect( 'aard_proj_hit' );ent.PlayEffect( 'aard_proj_hit' );
				ent.DestroyAfter(2);
				
				SoundEvent("cmb_petard_throw_swoosh");
				
				collidedEntities.PushBack(victim);
			}
		}
	}
	
	event OnDestroyed()
	{
		//theGame.witcherLog.AddMessage("AARD PROJ DESTROYED");
		RemoveTimer('check_targets_aard');
	}
}

statemachine class W3MQuenSphere extends CGameplayEntity 
{	
	var ent : CEntity;
	var movementAdjustor 														: CMovementAdjustor;
	var ticket 			 														: SMovementAdjustmentRequestTicket;	
	var targetent																: CEntity;
	var time 																	: float;
	var quen_action                                                             : W3DamageAction;
	var damage                                                                  : Float;
	var spellpower 																: SAbilityAttributeValue;
	var quen_victim																: CActor;	
	var entities 																: array< CGameplayEntity >;
	var randenemy, i 															: int;
	var pos,pos0																: Vector;
	var projectiles 															: array< CProjectileTrajectory >;
	
	timer function check_for_cancel(deltaTime : float, id : int) 
	{
		RemoveTimers();
		StopAllEffects();
		DestroyAfter(3);
	}
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		theSound.SoundLoadBank( "sign_yrden.bnk", false );
		PlayEffect('fire_fx_quen');
		AddTimer('check_for_cancel',1.2);
	}
	
	function fly_away_little_sphere() 
	{
		RemoveTimer('check_for_cancel');
		
		BreakAttachment();
		AddTimer('fly', 0.0000001f, true);
		AddTimer('shoot0', 1.35, true);
		//AddTimer('shoot_projs', 0.01, true);
		
		pos0 = TraceFloor( thePlayer.GetWorldPosition() );
	}
    timer function fly(deltaTime : float, id : int) 
	{
		pos = GetWorldPosition();
		pos.Z += 0.02;
		Teleport(pos);
		if ( VecDistance ( pos, pos0 ) >= 4 )
		{
			RemoveTimer('fly');
		}
	}
	
    timer function destroy_sphere(deltaTime : float, id : int) 
	{
		StopAllEffects();
		DestroyAfter(2);
		RemoveTimer('shoot0');
		RemoveTimer('shoot_projs');
	}
	
	event OnDestroyed()
	{
	}

    timer function shoot0(deltaTime : float, id : int) 
	{
		deal_damage();
		PlayEffectSingle('fire_fx_quen2_new');
	}
	
	timer function shoot_projs(deltaTime : float, id : int) 
	{
		var entities_proj 		: array< CGameplayEntity >;
		var p 					: int;
		var projj 				: CProjectileTrajectory;
		var entity_eff 			: CEntity;
		
		FindGameplayEntitiesInRange(entities_proj, thePlayer, 5, 100 );
		if( entities_proj.Size()>0 )
		{
			for ( p = 0; p <= entities_proj.Size(); p+=1 )
			{
				if ( ( CProjectileTrajectory )entities_proj[p] && !projectiles.Contains( ( CProjectileTrajectory )entities_proj[p] ) )
				{
					projj = (CProjectileTrajectory)entities_proj[p];
					if ( projj != thePlayer.rangedWeapon.GetDeployedEntity() && !projj.HasTag( 'fired_crossbow_bolt' ) && !projj.HasTag( 'spells_custom_projs' ) 
					&& ( W3ArrowProjectile )entities_proj[p] )
					{
						entity_eff = theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\adtomes\fistfight\quen_sphere_proj_dest.w2ent",true ), projj.GetWorldPosition()  );
						projectiles.PushBack( projj );
						projj.StopProjectile();
						projj.Destroy();
						this.PlayEffect('yrden_shock_activate', entity_eff );
						entity_eff.DestroyAfter(3);
						entity_eff.SoundEvent("sign_yrden_shock_activate");
					}
				}
			}
		}
	}
	
	
	function deal_damage()
	{
		var fxEntity : CEntity;
		
		entities.Clear();
		FindGameplayEntitiesInRange(entities, this, 10, 100, , FLAG_Attitude_Hostile+FLAG_OnlyAliveActors+FLAG_ExcludePlayer );
		if( entities.Size()>0 )
		{
			randenemy = RandRange ( entities.Size() );	
			quen_victim = (CActor)entities[randenemy];
			
			if ( GetAttitudeBetween( quen_victim, thePlayer ) == AIA_Hostile )				
			{
				this.SoundEvent("sign_yrden_shock_activate");
				
				ent = quen_victim.CreateFXEntityAtPelvis( 'explosions', true );
				ent.PlayEffect( 'old_gods_hit' );
				ent.DestroyAfter(5);
				ent.SoundEvent("sign_yrden_shock_activate");
			
				PlayEffect( 'yrden_shock_activate', ent );
			
				deal_damage_swordless_spells( S_Magic_4, quen_victim, 6, theGame.params.DAMAGE_NAME_SHOCK, true );
			}
		}
	}
}	


class W3MFrostGranade extends W3AdvancedProjectile
{
	protected var collidedEntities2 : array<CGameplayEntity>;
	var dmg_action                  : W3DamageAction;
	var victimsand					: CNewNPC;	
	var entities,entities2,entities3: array< CGameplayEntity >;
	var i	 						: int;
	var lastCollisionFxPos 			: Vector;
	var spellpower 					: SAbilityAttributeValue;
	var damage						: Float;
	var eff							: CEntity;
	var active 						: Bool;

	timer function check_for_cancel(deltaTime : float, id : int) 
	{
		if ( GetMagicDreamer().GetCurrentStateName() != 'Swordless_AttackHeavy' )
		{
			SoundEvent("fx_fire_burning_strong_end");
			SoundEvent("fx_fire_burning_body_strong_loop_end");
			RemoveTimers();
			StopAllEffects();
			DestroyAfter(1);
		}
	}

	timer function play_eff0(deltaTime : float, id : int) 
	{
		PlayEffect( 'fire_fx' );
	}
	timer function play_eff(deltaTime : float, id : int) 
	{
		PlayEffect( 'fire_fx3' );
	}
	timer function play_eff1(deltaTime : float, id : int) 
	{
		PlayEffect( 'fire_fx3' );
	}
	

    timer function check_targets(deltaTime : float, id : int) 
	{
		entities2.Clear();
		FindGameplayEntitiesInRange( entities2, this, 0.2, 2, , FLAG_Attitude_Hostile+FLAG_OnlyAliveActors+FLAG_ExcludePlayer );
		if ( entities2.Size() > 0 && active ) 
		{
			to_destroy();
			RemoveTimer('check_targets');
		}
	}
	
	event OnProjectileInit()
	{
		collidedEntities2.Clear();
		PlayEffect( 'fire_fx' );
		PlayEffect( 'fire_fx2' );
		AddTimer('play_eff0', 0.1);
		active = true;
		AddTimer('check_for_cancel',0.001, true);
		
		SoundEvent("fx_fire_burning_strong_begin");
		SoundEvent("fx_fire_burning_body_strong_loop");	
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
	
		if ( ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Static' ) || hitCollisionsGroups.Contains( 'Water' ) ) && active )
		{
			to_destroy();
		}
	}
	
	function to_destroy()
	{
		RemoveTimers();
		active = false;
		check_targets_frost();
		StopProjectile();
		DestroyAllEffects();
		PlayEffect( 'explosion' );
		DestroyAfter(10);
		
		SoundEvent("monster_golem_ifryt_vfx_proj_fire_line");
		SoundEvent('ep2_mutations_06_frosty_aard');
		SoundEvent("fx_fire_burning_strong_end");
		SoundEvent("fx_fire_burning_body_strong_loop_end");
		
		theGame.GetSurfacePostFX().AddSurfacePostFXGroup( GetWorldPosition(), 0.3f, 5, 1.f, 7.f, 0);
	}
	
	event OnDestroyed()
	{
	}
	
	function check_targets_frost()
	{
		var gheff 			: CEntity;
		var victim			: CActor;
	
		entities.Clear();
		FindGameplayEntitiesInSphere( entities, this.GetWorldPosition(), 4, 10 );
		
		if ( entities.Size() > 0 )
		for( i = 0; i < entities.Size(); i += 1 )
		{
			if ( !collidedEntities2.Contains(entities[i]) && entities[i] != thePlayer && entities[i] != this && !entities[i].HasTag('spells_custom_projs') )
			{
				entities[i].OnAardHit( NULL );
				collidedEntities2.PushBack(entities[i]);
			}
			
			victim = (CActor)entities[i];
			
			if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer 
				&& ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile) && victim.IsAlive() )
			{
				deal_damage_swordless_spells( S_Magic_5, victim, 6, theGame.params.DAMAGE_NAME_FROST, true );
				collidedEntities.PushBack(victim);
				
				gheff = victim.CreateFXEntityAtPelvis( 'wintersouls_effects', true );
				gheff.PlayEffect( 'wintersouls_flame' );
				gheff.DestroyAfter(5);
			}
		}
	}
}

class CSwordlessHeavy extends CGameplayEntity
{
	var actor 						: CActor;
	var effect_entity				: CEntity;
	var currentsign					: ESignType;
	var hand_effect 				: name;
	var sett 						: SAnimatedComponentSlotAnimationSettings;
	var path						: string;
	var proj_aard					: W3AardTrailHeavy;
	var proj_igni					: W3IgniTrailHeavy;
	var proj						: W3AdvancedProjectile;

	event OnSpawned( spawnData : SEntitySpawnData )
	{
		if ( !theSound.SoundIsBankLoaded("monster_golem_ice.bnk") )
		{
			theSound.SoundLoadBank( "monster_golem_ice.bnk", false );
		}
	
		PlayEffect('aard_heavy_fx');
		PlayEffect('aard_heavy_fx1');
		
		//AddTimer('initiate', 0.5 );
	}
	
	function initiate( nam : ESignType ) 
	{
		currentsign = nam;
		actor = GetMagicDreamer().actor_ag;
		
		effect_entity = actor.CreateFXEntityAtPelvis( 'swordless_hits', true );
		effect_entity.DestroyAfter(5);
		
		PlayEffect('aard_heavy_fx_drain', effect_entity );
		SoundEvent("monster_golem_ice_vfx_trail_loop_start");
		SoundEvent("monster_golem_ice_vfx_trail_loop_start");
		
		actor.PlayEffectSingle('axii_slowdown');
		actor.GetRootAnimatedComponent().FreezePoseFadeIn( 1 );
		
		AddTimer('hand_effect', 0.5 );
		AddTimer('attack', 0.9 );
	}
	
	timer function hand_effect(deltaTime : float, id : int) 
	{
		if ( currentsign == ST_Aard )
		{	hand_effect = 'aard_heavy_effect'; }
		else
		{	hand_effect = 'igni_heavy_effect_f'; }
		
		GetMagicEffectRight().PlayEffect( hand_effect );
	}
	
	timer function attack(deltaTime : float, id : int) 
	{
		attack_heavy_actual();
		AddTimer('attack_projectiles', 0.3, true);
	}
	timer function attack_projectiles( deltaTime : float , id : int)
	{
		attack_heavy_actual();
	}
	
	function attack_heavy_actual()
	{
		var targetpos	: Vector;
	
		if ( !actor.IsAlive() )
		{
			attack_heavy_force_stop();
		}
		else if ( thePlayer.GetStat( BCS_Stamina ) >= calc_stamina_swordless_spells( true, currentsign ) )
		{
			if ( currentsign == ST_Aard )
			{
				path = "dlc\magicspellsrev\data\entities\swordless\heavy_attack_aard_proj.w2ent";
				proj = (W3AardTrailHeavy)theGame.CreateEntity( (CEntityTemplate)LoadResource( path, true), thePlayer.GetWorldPosition() );
				proj.SoundEvent("cmb_weapon_swoosh_heavy_slow");
				drain_stamina_swordless_spells( ST_Aard, true );
				GetMagicEffectRight().PlayEffect( 'aard_heavy_effect2' );
				GetMagicEffectRight().StopEffect( 'aard_heavy_effect2' );
			}
			else
			{
				path = "dlc\magicspellsrev\data\entities\swordless\heavy_attack_igni_proj.w2ent";
				proj = (W3IgniTrailHeavy)theGame.CreateEntity( (CEntityTemplate)LoadResource( path, true), thePlayer.GetWorldPosition() );
				proj.SoundEvent("fx_fire_geralt_fire_hit");
				drain_stamina_swordless_spells( ST_Igni, true );
				GetMagicEffectRight().PlayEffect( 'igni_heavy_effect_f2' );
				GetMagicEffectRight().StopEffect( 'igni_heavy_effect_f2' );
			}
			proj.AddTag('spells_custom_projs');
			proj.CreateAttachment( GetMagicEffectRight(),,Vector( 0, 0, 0 ) );
			proj.Init(NULL);
			proj.BreakAttachment();
			
			targetpos = actor.GetBoneWorldPosition( spells_get_pelvis_name( actor ) );
			targetpos.Z += RandRangeF( 0.5, -0.4 );
			targetpos.Y += RandRangeF( 0.4, -0.4 );
			
			proj.ShootProjectileAtPosition( 0, 20, targetpos );
		}
		else
		{
			thePlayer.SoundEvent("gui_no_stamina");
			attack_heavy_force_stop();
			return;
		}
	}
	
	function attack_heavy_force_stop()
	{
		sett.blendIn = 1.f;
		sett.blendOut = 0.5f;
		thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_ger_sword_ignii_stop_lp_sword', 'PLAYER_SLOT', sett );
		
		GetMagicDreamer().PushState('Dreamer_Waiting');
	}
	
	timer function destroy_sw_heavy(deltaTime : float, id : int) 
	{
		//BreakAttachment();
		RemoveTag('swordless_heavy_fx_ent');
	
		RemoveTimers();
		StopAllEffects();
		
		actor.StopEffect('axii_slowdown');
		actor.GetRootAnimatedComponent().UnfreezePoseFadeOut( 2 );
		SoundEvent("monster_golem_ice_vfx_trail_loop_stop");
		
		GetMagicEffectRight().StopEffect( hand_effect );

		//GetMagicDreamer().AddTimer('raise_event_hack_start', StringToFloat( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_proj_timer' ) ) );
		//GetMagicDreamer().AddTimer('raise_event_hack_end', StringToFloat( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_proj_timer2' ) ) );


		DestroyAfter(3);
	}
	
}

class W3AardTrailHeavy extends W3AdvancedProjectile
{
	var name0, name1, name2, name3	: name;
	var actorVictim					: CActor;
	var ent 						: CEntity;
	var poseffect,posttest			: Vector;
	var entities					: array< CGameplayEntity >;
	var i 							: Int;
	var bonename 					: name;
	var meshComponent 				: CMeshComponent;


	event OnProjectileInit()
	{
		meshComponent = ( CMeshComponent ) this.GetComponentByClassName( 'CMeshComponent' );
		meshComponent.SetScale( Vector( 0, 0, 0 ) );
	
		PlayEffect('effect0');
		StopAllEffectsAfter(2);
		DestroyAfter(5);
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
	
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		
		if( collidingComponent )
		{	
			if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile) && victim.IsAlive())
			{
				deal_damage_swordless_spells( S_Magic_1, (CActor)victim, 6, theGame.params.DAMAGE_NAME_FORCE, true );
				
				SoundEvent("cmb_petard_throw_swoosh");
				
				PlayEffect('effect1');
				StopEffect('effect1');
				
				collidedEntities.PushBack(victim);
			}
		}
	}
	
	event OnDestroyed()
	{
	}
}


class W3IgniTrailHeavy extends W3AdvancedProjectile
{
	var name0, name1, name2, name3	: name;
	var actorVictim					: CActor;
	var ent 						: CEntity;
	var poseffect,posttest			: Vector;
	var entities					: array< CGameplayEntity >;
	var i 							: Int;
	var bonename 					: name;
	var meshComponent 				: CMeshComponent;
	var count 						: Int;

	event OnProjectileInit()
	{
		meshComponent = ( CMeshComponent ) this.GetComponentByClassName( 'CMeshComponent' );
		meshComponent.SetScale( Vector( 0, 0, 0 ) );
	
		PlayEffect('effect0');
		StopAllEffectsAfter(2);
		DestroyAfter(6);
		
		count = 0;
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
	
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		
		if( collidingComponent )
		{	
			if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile) && victim.IsAlive())
			{
				deal_damage_swordless_spells( S_Magic_2, (CActor)victim, 6, theGame.params.DAMAGE_NAME_FIRE, true );
				
				PlayEffect('effect1');
				StopEffect('effect1');
				
				collidedEntities.PushBack(victim);
				
				SoundEvent("cmb_petard_throw_swoosh");
			}
		}
	}
	
	event OnDestroyed()
	{
	}
}
